<?php
session_start();
if(!isset($_SESSION['id'])) header("Location: login.php");
include "includes/header.php";
?>

<div class="pt-28 px-5 max-w-2xl mx-auto">
    <h1 class="text-2xl font-bold mb-6 text-center">
        <i class="fa-solid fa-search mr-2"></i> Verificar Conteúdo
    </h1>

    <div class="card p-5 rounded-2xl mb-6 shadow-md"
         style="background: var(--menu-bg); border:1px solid var(--border-color); color: var(--text-primary);">

        <input id="search" placeholder="Pesquisar por título ou categoria" class="p-3 rounded-xl w-full mb-4" style="background:var(--menu-secondary); border:1px solid var(--border-color); color:var(--text-primary);">

        <div class="toggle-group mb-4">
            <input type="radio" name="tipo" id="t1" value="todos" checked><label for="t1">Todos</label>
            <input type="radio" name="tipo" id="t2" value="canal"><label for="t2">Canais</label>
            <input type="radio" name="tipo" id="t3" value="filme"><label for="t3">Filmes</label>
            <input type="radio" name="tipo" id="t4" value="serie"><label for="t4">Séries</label>
        </div>

        <div class="flex gap-4 mb-4">
            <div class="p-3 rounded-xl" style="background:var(--menu-secondary); border:1px solid var(--border-color);">
                <b>Total:</b> <span id="total_count">0</span>
            </div>
            <div class="p-3 rounded-xl" style="background:var(--menu-secondary); border:1px solid var(--border-color);">
                <b>Filmes:</b> <span id="count_filmes">0</span>
            </div>
            <div class="p-3 rounded-xl" style="background:var(--menu-secondary); border:1px solid var(--border-color);">
                <b>Séries:</b> <span id="count_series">0</span>
            </div>
            <div class="p-3 rounded-xl" style="background:var(--menu-secondary); border:1px solid var(--border-color);">
                <b>Canais:</b> <span id="count_canais">0</span>
            </div>
        </div>

        <div id="list" class="swiper mySwiper" style="min-height:200px;">
            <p class="text-center text-gray-500">Carregando conteúdos...</p>
        </div>
    </div>
</div>

<!-- Swiper CSS/JS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css"/>
<script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>

<script>
let batch = 20;
let offset = 0;
let loading = false;
const listDiv = document.getElementById('list');

async function loadBatch(){
    if(loading) return;
    loading = true;
    const res = await fetch('verificar_ajax.php?start='+offset+'&count='+batch);
    const data = await res.json();
    if(!data.items || data.items.length===0){ loading=false; return; }

    // atualiza contagem
    document.getElementById('total_count').textContent = data.counts.total;
    document.getElementById('count_filmes').textContent = data.counts.filme;
    document.getElementById('count_series').textContent = data.counts.serie;
    document.getElementById('count_canais').textContent = data.counts.canal;

    // limpa placeholder na primeira vez
    if(offset===0) listDiv.innerHTML='';

    data.items.forEach(it=>{
        const div = document.createElement('div');
        div.className = 'swiper-slide flex flex-col items-center p-2 rounded-xl shadow-md';
        div.style.background = 'var(--menu-secondary)';
        div.innerHTML = `
            <img src="${it.logo || 'https://via.placeholder.com/120x160?text=?'}" style="width:120px;height:160px;object-fit:cover;border-radius:6px;">
            <b style="margin-top:5px;">${it.title}</b>
            <small style="color:var(--text-secondary)">${it.type} | ${it.group}</small>
            <button class="btn-tmdb p-1 mt-1 rounded-xl" data-title="${it.title}" data-type="${it.type}" style="background:var(--accent);color:#fff;">TMDB</button>
            <div class="tmdb-result text-xs mt-1" style="color:var(--text-secondary)"></div>
        `;
        listDiv.appendChild(div);
    });

    offset += batch;
    loading = false;

    if(!window.swiperInstance){
        window.swiperInstance = new Swiper('.mySwiper',{
            slidesPerView: 1.5,
            spaceBetween:10,
            breakpoints:{640:{slidesPerView:2.5},768:{slidesPerView:3.5},1024:{slidesPerView:5}}
        });
    } else window.swiperInstance.update();
}

// Lazy load infinito
window.addEventListener('scroll',()=>{
    if(window.innerHeight + window.scrollY >= document.body.offsetHeight - 150){
        loadBatch();
    }
});

// Inicial
loadBatch();
</script>